/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.text.hyperlink;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.outline.PathResolverProvider;
import com.aptana.editor.common.resolver.IPathResolver;
import com.aptana.editor.common.text.hyperlink.URIHyperlink;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.URLHyperlink;
import org.eclipse.jface.text.hyperlink.URLHyperlinkDetector;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;

public class HyperlinkDetector
extends URLHyperlinkDetector {
    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        IHyperlink[] result = super.detectHyperlinks(textViewer, region, canShowMultipleHyperlinks);
        if (result == null) {
            String value;
            String line;
            IRegion lineInfo;
            IDocument document = textViewer.getDocument();
            int offset = region.getOffset();
            if (document == null) {
                return null;
            }
            IRegion hyperLinkRegion = region;
            try {
                lineInfo = document.getLineInformationOfOffset(offset);
                line = document.get(lineInfo.getOffset(), lineInfo.getLength());
                value = document.get(region.getOffset(), region.getLength());
            }
            catch (BadLocationException ex) {
                return null;
            }
            int relativeOffset = region.getOffset() - lineInfo.getOffset();
            int afterIndex = line.indexOf(34, relativeOffset);
            if (afterIndex != -1) {
                String prefix = line.substring(0, relativeOffset);
                int beforeIndex = prefix.lastIndexOf(34);
                value = line.substring(beforeIndex + 1, afterIndex);
                hyperLinkRegion = new Region(lineInfo.getOffset() + beforeIndex + 1, value.length());
            }
            if (StringUtil.isEmpty((String)value)) {
                return null;
            }
            IEditorPart part = (IEditorPart)this.getAdapter(IEditorPart.class);
            if (part == null) {
                return null;
            }
            IEditorInput input = part.getEditorInput();
            IPathResolver resolver = PathResolverProvider.getResolver(input);
            try {
                URI uri = resolver.resolveURI(value);
                if (uri != null) {
                    return new IHyperlink[]{new URIHyperlink(hyperLinkRegion, uri)};
                }
            }
            catch (Exception e) {
                IdeLog.logInfo((Plugin)CommonEditorPlugin.getDefault(), (String)MessageFormat.format("Failed to resolve ''{0}'' as hyperlink url", value), (Throwable)e, (String)"com.aptana.editor.common/debug");
            }
            return null;
        }
        ArrayList<URIHyperlink> ours = new ArrayList<URIHyperlink>(result.length);
        IHyperlink[] iHyperlinkArray = result;
        int n = result.length;
        int n2 = 0;
        while (n2 < n) {
            IHyperlink link = iHyperlinkArray[n2];
            URLHyperlink hyperlink = (URLHyperlink)link;
            try {
                URIHyperlink wrapped = new URIHyperlink(hyperlink);
                if (wrapped.hasAssociatedEditor()) {
                    ours.add(wrapped);
                }
            }
            catch (URISyntaxException use) {
                IdeLog.logInfo((Plugin)CommonEditorPlugin.getDefault(), (String)MessageFormat.format("Failed to resolve URI: {0}", hyperlink.getURLString()), (Throwable)use, (String)"com.aptana.editor.common/debug");
            }
            catch (MalformedURLException mue) {
                IdeLog.logInfo((Plugin)CommonEditorPlugin.getDefault(), (String)MessageFormat.format("Failed to resolve URI: {0}", hyperlink.getURLString()), (Throwable)mue, (String)"com.aptana.editor.common/debug");
            }
            ++n2;
        }
        if (ours.isEmpty()) {
            return null;
        }
        return ours.toArray(new IHyperlink[ours.size()]);
    }
}

